/*
 *  File:		utils.h
 *  Function:	header for the utility functions
 *  Author:		Paul Elseth
 *				Copyright (c) 1991, Paul Elseth
 *
 *	Change History:
 *
 *		12/03/91	PBE		created
 */

#ifndef	__UTILS__
#define	__UTILS__

#ifndef __TYPES__
#include <types.h>
#endif

#ifndef __WINDOW__
#include <window.h>
#endif

typedef enum {
	ActEditNative,
    ActEditScriptEdit,
    ActEditHexEdit,
    ActEditAttributes,
    ActDelete,
    ActExport } ActionType;


short		AddPrivateData(WindowPtr wp, Handle dataH, short groupSig, short type, long id);
Handle		GetPrivateData(WindowPtr wp);
short		LoadAResource(short type, long id, Handle *h);
short		GetWindowTitle(short type, long id, char *buffer);
short		CloseAWindow(WindowPtr wp);
short		WriteAResource(short type, long id);
short		ReleaseAResource(short type, long id);
short		SelectAction(short type, long id, ActionType action);
short		AddPickerMenu(short resID);
short		LoadMyResource(short type, long id, Handle *h);
short		DetachMyResource(short type, long id);

void		SysError(short err);
void		SetMyCursor(Cursor *cp);
void		SetArrowCursor(void);
void		SetWaitCursor(void);

void		MakePattern(short color, Pattern pat);


#endif	/* __UTILS__ */
